(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
One Time Pad Cryptosystem
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; locked; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; locked; preserveAspect; endGroup]
This Notebook contains output from a simulation of a one time pad cryptosystem. See "Explorations in Quantum Computing", Chapter 6. One time pads are extremely secure cryptosystems provided the identity of the key pads remains secret i.e. known only to the sender and the intended recipient of the messages.

Quantum key distribution could be used to distribute new keys for a one time pad in an "as needed" but highly secure fashion. See "Explorations in Quantum Computing", Chapter 8 for more information on quantum key distribution.

Please note that all active components of our implementation of the OTP cryptosystem have been deleted from this CD-ROM to ensure compliance with U.S. Federal Law regarding Department of Commerce prohibitions on the export of cryptographic software.  The examples below are sufficient to illustrate the general principles behind One Time Pads but they will not permit you to generate any new examples for yourself. We may be able to export the active code components of the One Time Pad simulator in the future subject to U.S. government approval.
:[font = section; inactive; locked; preserveAspect; startGroup]
Encryption/Decryption Using "One Time Pads"
:[font = text; inactive; locked; preserveAspect]
One time pads are extremely secure but they require the person who sends a coded message to meet with the person who will receive the coded message beforehand and covertly agree upon a common pad of keys. One the key pad has been created and a copy given to the sender and receiver of a message secure messages can be exchanged as follows: 
:[font = text; inactive; locked; preserveAspect]
A message is a string of symbols from some finite alphabet. Each distinct symbol is associated with a unique integer in the range 0 to l-1, where  l is the number of symbols in the "alphabet". The i-th encrypted integer is the sum (modulo l) of the i-th message integer plus the i-th key integer (on the agreed upon page in the pre-computed pad of keys). Thus, 
:[font = input; locked; preserveAspect]
Message (converted to integers) = {m1, m2, m3, ..., mN}
Keys                            = {k1, k2, k3, ..., kN}
Encrypted Message               = {e1, e2, e3, ..., eN} 

:[font = text; inactive; locked; preserveAspect; endGroup]
where ei = mi + ki (mod l).
:[font = section; inactive; locked; preserveAspect; startGroup]
Example of a One Time Pad
:[font = text; inactive; locked; preserveAspect]
Here is an example of a message encrypted and decrypted using a One Time Pad. 

Suppose Alice wishes to send a message to Bob.  To do so, Alice and Bob must already have met and agreed upon certain rules of communication. First they have agreed to use the same alphabet, such as $Alphabet below:

:[font = input; locked; initialization; preserveAspect]
*)
$Alphabet =
	{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", 
	 "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", 
	 "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", 
	 "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", 
	 "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", 
	 "4", "5", "6", "7", "8", "9", "0", "!", "?", ".", ",", 
	 ";", ":", "(", ")", "{", "}", "[", "]", " ", "'"};

(*
:[font = text; inactive; locked; preserveAspect]
Moreover, Alice and Bob must already have agreed to associate each symbol in the alphabet with a unique integer between 0 and l-1 where l is the number of distinct symbols in the alphabet. The association is arbitrary so long as Alice and Bob use it consistently and all characters have an equal number of digits. Here is a simple encoding ...
:[font = input; locked; preserveAspect; startGroup]
MessageToIntegers["abcdef   ABCDEF", $Alphabet]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
{0, 1, 2, 3, 4, 5, 74, 74, 74, 26, 27, 28, 29, 30, 31}
;[o]
{0, 1, 2, 3, 4, 5, 74, 74, 74, 26, 27, 28, 29, 30, 31}
:[font = text; inactive; locked; preserveAspect]
Notice a blank space is assigned the integer 74. Thus a proper message would look something like this ... 
:[font = input; locked; preserveAspect; startGroup]
MessageToIntegers["Telephone 555 1212!", $Alphabet]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}
;[o]
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}
:[font = text; inactive; locked; preserveAspect]
Also, and most importantly, Alice and Bob must have already generated a huge set of random integers, or "keys", uniformly in the range 0 to l-1 and recorded them in 2 identical booklets or "pads", one kept by Alice and the other by Bob. When Alice or Bob want to send a message, they begin by informing the other party (publicly) which page they are using as the source of the keys. Provided they have guarded the key pads from other people, this communicates no useful information to an adversary. Moreover, once the message has been encrypted, transmitted and decoded successfully Alice and Bob rip out the page in the key pad that was used as the source of keys, never to use it again. The use of pads of keys that are used only once explains the reason for the name "one time pad".
:[font = input; locked; preserveAspect; startGroup]
?MakeKeyPad
:[font = print; inactive; locked; preserveAspect; endGroup]
MakeKeyPad[alphabet, n, k] creates a pad of keys containing n pages and k keys per
   page. Each key is a random integer picked uniformly and independently in the
   range 0 to Length[alphabet]-1.
:[font = input; locked; initialization; preserveAspect]
*)
$Pad = MakeKeyPad[$Alphabet, 1000, 100];
(*
:[font = text; inactive; locked; preserveAspect]
In this case the pad, $Pad, contains 1000 pages of 100 keys per page. Here are the first 10 pages of the pad, $Pad, written one page per line:
:[font = input; locked; preserveAspect; startGroup]
SetOptions[$Output, PageWidth->Infinity];
MatrixForm[Take[$Pad, {1, 10}]]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
MatrixForm[{{54, 0, 72, 25, 41, 52, 36, 34, 56, 42, 48, 27, 70, 33, 16, 0, 22, 22, 56, 2, 21, 39, 24, 33, 11, 58, 38, 37, 30, 2, 54, 43, 19, 6, 58, 20, 8, 36, 70, 26, 26, 30, 34, 25, 60, 6, 72, 12, 14, 71, 72, 24, 46, 69, 67, 57, 35, 62, 75, 30, 18, 65, 58, 2, 38, 38, 63, 50, 32, 60, 9, 67, 46, 75, 4, 36, 57, 24, 22, 0, 55, 50, 4, 20, 26, 44, 28, 61, 69, 48, 44, 27, 56, 12, 22, 9, 58, 24, 36, 17}, {54, 31, 35, 29, 10, 64, 73, 20, 66, 51, 30, 64, 64, 17, 57, 11, 44, 58, 51, 73, 62, 28, 30, 9, 14, 3, 60, 74, 62, 50, 54, 71, 56, 32, 54, 19, 58, 15, 40, 9, 60, 62, 11, 64, 51, 60, 30, 42, 14, 46, 56, 58, 10, 70, 27, 70, 0, 36, 26, 22, 43, 53, 72, 6, 26, 7, 40, 18, 74, 69, 19, 17, 15, 8, 37, 11, 71, 36, 70, 68, 52, 44, 62, 17, 69, 60, 62, 31, 14, 43, 64, 42, 56, 7, 5, 25, 43, 60, 26, 45}, {48, 60, 25, 17, 47, 1, 61, 39, 21, 30, 63, 68, 39, 10, 39, 0, 12, 35, 49, 60, 51, 71, 32, 4, 58, 49, 27, 16, 16, 69, 49, 4, 48, 74, 65, 55, 45, 52, 75, 48, 33, 9, 11, 9, 69, 37, 61, 70, 53, 39, 47, 48, 53, 43, 44, 40, 17, 52, 4, 5, 3, 45, 61, 12, 62, 7, 49, 3, 41, 55, 46, 58, 7, 14, 8, 55, 48, 13, 12, 48, 61, 43, 11, 13, 19, 5, 42, 64, 32, 8, 27, 15, 49, 68, 8, 30, 42, 11, 30, 33}, {24, 1, 40, 33, 70, 9, 16, 21, 70, 5, 0, 57, 49, 8, 48, 6, 11, 75, 13, 5, 17, 22, 7, 71, 21, 7, 2, 36, 72, 15, 75, 47, 43, 37, 56, 42, 2, 46, 70, 2, 70, 35, 63, 57, 34, 48, 53, 35, 18, 49, 36, 46, 29, 30, 14, 17, 42, 64, 50, 47, 53, 45, 19, 70, 70, 32, 60, 60, 66, 10, 56, 20, 38, 0, 72, 67, 47, 8, 22, 47, 43, 18, 15, 70, 19, 71, 49, 41, 50, 70, 50, 18, 33, 58, 68, 62, 48, 60, 9, 24}, {74, 25, 64, 35, 39, 23, 24, 53, 25, 65, 51, 59, 65, 32, 15, 23, 48, 37, 8, 34, 31, 3, 69, 15, 38, 42, 62, 11, 4, 55, 1, 32, 53, 7, 16, 34, 36, 20, 65, 68, 18, 27, 66, 51, 75, 29, 53, 22, 41, 61, 4, 19, 3, 14, 67, 14, 57, 6, 28, 41, 70, 9, 23, 13, 47, 5, 65, 65, 22, 15, 6, 60, 36, 27, 70, 46, 42, 68, 23, 37, 51, 60, 14, 34, 1, 61, 73, 63, 59, 26, 4, 7, 25, 38, 22, 65, 15, 63, 47, 46}, {69, 62, 70, 38, 38, 18, 63, 12, 37, 35, 47, 22, 52, 70, 46, 12, 64, 66, 25, 3, 2, 58, 69, 69, 60, 64, 59, 13, 59, 19, 75, 15, 64, 34, 25, 50, 10, 1, 72, 52, 60, 1, 34, 40, 72, 62, 74, 54, 6, 18, 63, 13, 67, 6, 47, 6, 17, 7, 20, 66, 13, 70, 8, 75, 5, 7, 19, 49, 42, 57, 19, 42, 25, 32, 27, 28, 0, 65, 11, 51, 26, 13, 20, 59, 21, 55, 40, 39, 19, 52, 41, 61, 55, 41, 27, 1, 12, 57, 29, 37}, {33, 55, 43, 75, 41, 10, 22, 39, 39, 6, 21, 9, 3, 48, 56, 12, 34, 3, 75, 2, 65, 26, 21, 18, 35, 33, 47, 53, 69, 66, 40, 54, 19, 15, 42, 54, 62, 9, 23, 70, 33, 15, 62, 38, 64, 74, 34, 23, 64, 11, 60, 46, 63, 27, 59, 2, 21, 43, 18, 19, 67, 15, 63, 13, 19, 59, 4, 39, 70, 34, 36, 67, 18, 27, 66, 23, 21, 14, 31, 12, 73, 55, 28, 16, 13, 6, 51, 35, 68, 23, 46, 56, 28, 20, 59, 26, 30, 29, 59, 9}, {65, 19, 62, 36, 12, 33, 5, 40, 36, 23, 27, 6, 38, 14, 57, 17, 10, 42, 56, 74, 7, 33, 15, 26, 28, 52, 61, 62, 15, 37, 37, 3, 38, 33, 13, 66, 11, 23, 3, 44, 25, 57, 58, 58, 37, 72, 40, 72, 5, 35, 28, 36, 65, 15, 59, 48, 34, 9, 0, 20, 27, 63, 41, 69, 49, 51, 9, 71, 8, 55, 37, 50, 20, 66, 8, 32, 46, 43, 6, 26, 35, 10, 9, 47, 26, 24, 26, 5, 42, 4, 9, 23, 39, 40, 69, 66, 13, 42, 26, 9}, {46, 60, 41, 67, 33, 60, 32, 25, 9, 4, 10, 33, 65, 70, 33, 54, 52, 36, 10, 18, 39, 59, 51, 16, 19, 39, 1, 28, 56, 24, 65, 11, 29, 66, 40, 42, 38, 22, 22, 24, 11, 34, 48, 25, 66, 49, 48, 44, 34, 29, 34, 28, 61, 62, 59, 49, 28, 67, 29, 43, 11, 41, 18, 33, 34, 40, 13, 17, 3, 73, 21, 3, 25, 70, 2, 39, 36, 65, 61, 45, 72, 25, 46, 18, 14, 40, 37, 23, 39, 70, 27, 3, 54, 44, 37, 67, 0, 44, 8, 57}, {50, 9, 74, 8, 6, 58, 46, 67, 63, 52, 10, 5, 52, 34, 41, 67, 4, 14, 75, 52, 29, 47, 1, 64, 52, 55, 44, 55, 58, 69, 40, 52, 28, 65, 31, 0, 74, 16, 45, 54, 37, 14, 49, 52, 2, 24, 4, 41, 5, 0, 39, 75, 6, 55, 59, 55, 39, 61, 3, 7, 73, 4, 13, 7, 28, 21, 52, 37, 33, 41, 48, 16, 38, 14, 64, 42, 19, 43, 16, 6, 53, 50, 24, 34, 49, 48, 66, 70, 17, 61, 8, 38, 62, 72, 21, 1, 40, 0, 74, 67}}]
;[o]
54   0    72   25   41   52   36   34   56   42   48   27   70   33   16   0    22   22   56   2    21   39   24   33   11   58   38   37   30   2    54   43   19   6    58   20   8    36   70   26   26   30   34   25   60   6    72   12   14   71   72   24   46   69   67   57   35   62   75   30   18   65   58   2    38   38   63   50   32   60   9    67   46   75   4    36   57   24   22   0    55   50   4    20   26   44   28   61   69   48   44   27   56   12   22   9    58   24   36   17

54   31   35   29   10   64   73   20   66   51   30   64   64   17   57   11   44   58   51   73   62   28   30   9    14   3    60   74   62   50   54   71   56   32   54   19   58   15   40   9    60   62   11   64   51   60   30   42   14   46   56   58   10   70   27   70   0    36   26   22   43   53   72   6    26   7    40   18   74   69   19   17   15   8    37   11   71   36   70   68   52   44   62   17   69   60   62   31   14   43   64   42   56   7    5    25   43   60   26   45

48   60   25   17   47   1    61   39   21   30   63   68   39   10   39   0    12   35   49   60   51   71   32   4    58   49   27   16   16   69   49   4    48   74   65   55   45   52   75   48   33   9    11   9    69   37   61   70   53   39   47   48   53   43   44   40   17   52   4    5    3    45   61   12   62   7    49   3    41   55   46   58   7    14   8    55   48   13   12   48   61   43   11   13   19   5    42   64   32   8    27   15   49   68   8    30   42   11   30   33

24   1    40   33   70   9    16   21   70   5    0    57   49   8    48   6    11   75   13   5    17   22   7    71   21   7    2    36   72   15   75   47   43   37   56   42   2    46   70   2    70   35   63   57   34   48   53   35   18   49   36   46   29   30   14   17   42   64   50   47   53   45   19   70   70   32   60   60   66   10   56   20   38   0    72   67   47   8    22   47   43   18   15   70   19   71   49   41   50   70   50   18   33   58   68   62   48   60   9    24

74   25   64   35   39   23   24   53   25   65   51   59   65   32   15   23   48   37   8    34   31   3    69   15   38   42   62   11   4    55   1    32   53   7    16   34   36   20   65   68   18   27   66   51   75   29   53   22   41   61   4    19   3    14   67   14   57   6    28   41   70   9    23   13   47   5    65   65   22   15   6    60   36   27   70   46   42   68   23   37   51   60   14   34   1    61   73   63   59   26   4    7    25   38   22   65   15   63   47   46

69   62   70   38   38   18   63   12   37   35   47   22   52   70   46   12   64   66   25   3    2    58   69   69   60   64   59   13   59   19   75   15   64   34   25   50   10   1    72   52   60   1    34   40   72   62   74   54   6    18   63   13   67   6    47   6    17   7    20   66   13   70   8    75   5    7    19   49   42   57   19   42   25   32   27   28   0    65   11   51   26   13   20   59   21   55   40   39   19   52   41   61   55   41   27   1    12   57   29   37

33   55   43   75   41   10   22   39   39   6    21   9    3    48   56   12   34   3    75   2    65   26   21   18   35   33   47   53   69   66   40   54   19   15   42   54   62   9    23   70   33   15   62   38   64   74   34   23   64   11   60   46   63   27   59   2    21   43   18   19   67   15   63   13   19   59   4    39   70   34   36   67   18   27   66   23   21   14   31   12   73   55   28   16   13   6    51   35   68   23   46   56   28   20   59   26   30   29   59   9

65   19   62   36   12   33   5    40   36   23   27   6    38   14   57   17   10   42   56   74   7    33   15   26   28   52   61   62   15   37   37   3    38   33   13   66   11   23   3    44   25   57   58   58   37   72   40   72   5    35   28   36   65   15   59   48   34   9    0    20   27   63   41   69   49   51   9    71   8    55   37   50   20   66   8    32   46   43   6    26   35   10   9    47   26   24   26   5    42   4    9    23   39   40   69   66   13   42   26   9

46   60   41   67   33   60   32   25   9    4    10   33   65   70   33   54   52   36   10   18   39   59   51   16   19   39   1    28   56   24   65   11   29   66   40   42   38   22   22   24   11   34   48   25   66   49   48   44   34   29   34   28   61   62   59   49   28   67   29   43   11   41   18   33   34   40   13   17   3    73   21   3    25   70   2    39   36   65   61   45   72   25   46   18   14   40   37   23   39   70   27   3    54   44   37   67   0    44   8    57

50   9    74   8    6    58   46   67   63   52   10   5    52   34   41   67   4    14   75   52   29   47   1    64   52   55   44   55   58   69   40   52   28   65   31   0    74   16   45   54   37   14   49   52   2    24   4    41   5    0    39   75   6    55   59   55   39   61   3    7    73   4    13   7    28   21   52   37   33   41   48   16   38   14   64   42   19   43   16   6    53   50   24   34   49   48   66   70   17   61   8    38   62   72   21   1    40   0    74   67
:[font = text; inactive; locked; preserveAspect]
Next Alice encodes her message by first mapping each symbol in the message to the corresponding number for that symbol in the alphabet ...
:[font = input; locked; preserveAspect; startGroup]
MessageToIntegers["Telephone 555 1212!", $Alphabet]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}
;[o]
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}
:[font = text; inactive; locked; preserveAspect]
... and then adding a random integer to that number modulo l. In this case the message contains 19 characters so Alice is using the first 19 integers on page 7 of her (and Bob's) key pad, $Pad. 
:[font = input; locked; preserveAspect; startGroup]
Take[$Pad[[7]], {1, 19}]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
{33, 55, 43, 75, 41, 10, 22, 39, 39, 6, 21, 9, 3, 48, 56, 12, 34, 3, 75}
;[o]
{33, 55, 43, 75, 41, 10, 22, 39, 39, 6, 21, 9, 3, 48, 56, 12, 34, 3, 75}
:[font = text; inactive; locked; preserveAspect]
Using the first 19 integers on page 7 of the pad, Alice can encrypt a message:
:[font = input; locked; preserveAspect; startGroup]
cipher = EncryptOTP["Telephone 555 1212!", 7, $Pad, $Alphabet]
:[font = output; output; inactive; locked; preserveAspect; endGroup]
{2, 59, 54, 3, 56, 17, 36, 52, 43, 4, 1, 65, 59, 46, 32, 65, 10, 56, 61}
;[o]
{2, 59, 54, 3, 56, 17, 36, 52, 43, 4, 1, 65, 59, 46, 32, 65, 10, 56, 61}
:[font = text; inactive; locked; preserveAspect]
Upon, receipt of an encrypted message, Bob must use the same set of keys that Alice used to encrypt the message to decrypt the message. In particular, Alice must tell Bob she used page 7 of the shared pad, so he can figure out what the random "noise" integers must have been. After unscrambling the message back to a sequence of integers, Bob then inverts the encoding of symbols as integers by calling IntegersToMessage (the inverse of MessageToIntegers). Bundling these steps together gives us DecryptOTP.
:[font = input; locked; preserveAspect; startGroup]
DecryptOTP[cipher, 7, $Pad, $Alphabet]
:[font = output; output; inactive; locked; preserveAspect; endGroup; endGroup]
"Telephone 555 1212!"
;[o]
Telephone 555 1212!
:[font = section; inactive; locked; preserveAspect; startGroup]
Frequency of Letters in English
:[font = text; inactive; locked; preserveAspect]
Frequency of letters in 1000 characters of English. Source - Dominic Welsh, "Codes & Cryptography", Oxford Science Publications  (1988), p231
:[font = input; locked; preserveAspect; startGroup]
Needs["Graphics`Graphics`"];

freqInEnglishData =
{{"a", 1, 64},  {"b", 2, 14},  {"c", 3, 27},  {"d", 4, 35}, 
 {"e", 5, 100}, {"f", 6, 20},  {"g", 7, 14},  {"h", 8, 42}, 
 {"i", 9, 63},  {"j", 10, 3},  {"k", 11, 6},  {"l", 12, 35}, 
 {"m", 13, 20}, {"n", 14, 56}, {"o", 15, 56}, {"p", 16, 17}, 
 {"q", 17, 4},  {"r", 18, 49}, {"s", 19, 56}, {"t", 20, 71}, 
 {"u", 21, 31}, {"v", 22, 10}, {"w", 23, 18}, {"x", 24, 3}, 
 {"y", 25, 18}, {"z", 26, 2},  {"_", 27, 166}};

PlotFreqInEnglish[data_]:=
	Module[{labels},
		labels = Map[#[[1]]&, data];
		BarChart[Map[#[[3]]&, data],
		         BarLabels->labels,
		         BarSpacing->0.1,
		         BarEdges->False,
		         BarStyle->{GrayLevel[0.6]},
		         PlotRange->All,
		         Frame->True, Axes->False, GridLines->Automatic]
	];

PlotFreqInEnglish[freqInEnglishData]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00062422 0.0356697 0.0147151 0.00354581 [
[(a)] .03629 0 0 2 Msboxa
[(b)] .07196 0 0 2 Msboxa
[(c)] .10763 0 0 2 Msboxa
[(d)] .1433 0 0 2 Msboxa
[(e)] .17897 0 0 2 Msboxa
[(f)] .21464 0 0 2 Msboxa
[(g)] .25031 0 0 2 Msboxa
[(h)] .28598 0 0 2 Msboxa
[(i)] .32165 0 0 2 Msboxa
[(j)] .35732 0 0 2 Msboxa
[(k)] .39299 0 0 2 Msboxa
[(l)] .42866 0 0 2 Msboxa
[(m)] .46433 0 0 2 Msboxa
[(n)] .5 0 0 2 Msboxa
[(o)] .53567 0 0 2 Msboxa
[(p)] .57134 0 0 2 Msboxa
[(q)] .60701 0 0 2 Msboxa
[(r)] .64268 0 0 2 Msboxa
[(s)] .67835 0 0 2 Msboxa
[(t)] .71402 0 0 2 Msboxa
[(u)] .74969 0 0 2 Msboxa
[(v)] .78536 0 0 2 Msboxa
[(w)] .82103 0 0 2 Msboxa
[(x)] .8567 0 0 2 Msboxa
[(y)] .89237 0 0 2 Msboxa
[(z)] .92804 0 0 2 Msboxa
[(_)] .96371 0 0 2 Msboxa
[(0)] -0.0125 .01472 1 0 Msboxa
[(25)] -0.0125 .10336 1 0 Msboxa
[(50)] -0.0125 .19201 1 0 Msboxa
[(75)] -0.0125 .28065 1 0 Msboxa
[(100)] -0.0125 .3693 1 0 Msboxa
[(125)] -0.0125 .45794 1 0 Msboxa
[(150)] -0.0125 .54659 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17897 0 m
.17897 .61803 L
s
P
p
0 0 .5 r
.001 w
.35732 0 m
.35732 .61803 L
s
P
p
0 0 .5 r
.001 w
.53567 0 m
.53567 .61803 L
s
P
p
0 0 .5 r
.001 w
.71402 0 m
.71402 .61803 L
s
P
p
0 0 .5 r
.001 w
.89237 0 m
.89237 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .10336 m
1 .10336 L
s
P
p
0 0 .5 r
.001 w
0 .19201 m
1 .19201 L
s
P
p
0 0 .5 r
.001 w
0 .28065 m
1 .28065 L
s
P
p
0 0 .5 r
.001 w
0 .3693 m
1 .3693 L
s
P
p
0 0 .5 r
.001 w
0 .45794 m
1 .45794 L
s
P
p
0 0 .5 r
.001 w
0 .54659 m
1 .54659 L
s
P
p
.002 w
.03629 0 m
.03629 .00625 L
s
P
[(a)] .03629 0 0 2 Mshowa
p
.002 w
.07196 0 m
.07196 .00625 L
s
P
[(b)] .07196 0 0 2 Mshowa
p
.002 w
.10763 0 m
.10763 .00625 L
s
P
[(c)] .10763 0 0 2 Mshowa
p
.002 w
.1433 0 m
.1433 .00625 L
s
P
[(d)] .1433 0 0 2 Mshowa
p
.002 w
.17897 0 m
.17897 .00625 L
s
P
[(e)] .17897 0 0 2 Mshowa
p
.002 w
.21464 0 m
.21464 .00625 L
s
P
[(f)] .21464 0 0 2 Mshowa
p
.002 w
.25031 0 m
.25031 .00625 L
s
P
[(g)] .25031 0 0 2 Mshowa
p
.002 w
.28598 0 m
.28598 .00625 L
s
P
[(h)] .28598 0 0 2 Mshowa
p
.002 w
.32165 0 m
.32165 .00625 L
s
P
[(i)] .32165 0 0 2 Mshowa
p
.002 w
.35732 0 m
.35732 .00625 L
s
P
[(j)] .35732 0 0 2 Mshowa
p
.002 w
.39299 0 m
.39299 .00625 L
s
P
[(k)] .39299 0 0 2 Mshowa
p
.002 w
.42866 0 m
.42866 .00625 L
s
P
[(l)] .42866 0 0 2 Mshowa
p
.002 w
.46433 0 m
.46433 .00625 L
s
P
[(m)] .46433 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(n)] .5 0 0 2 Mshowa
p
.002 w
.53567 0 m
.53567 .00625 L
s
P
[(o)] .53567 0 0 2 Mshowa
p
.002 w
.57134 0 m
.57134 .00625 L
s
P
[(p)] .57134 0 0 2 Mshowa
p
.002 w
.60701 0 m
.60701 .00625 L
s
P
[(q)] .60701 0 0 2 Mshowa
p
.002 w
.64268 0 m
.64268 .00625 L
s
P
[(r)] .64268 0 0 2 Mshowa
p
.002 w
.67835 0 m
.67835 .00625 L
s
P
[(s)] .67835 0 0 2 Mshowa
p
.002 w
.71402 0 m
.71402 .00625 L
s
P
[(t)] .71402 0 0 2 Mshowa
p
.002 w
.74969 0 m
.74969 .00625 L
s
P
[(u)] .74969 0 0 2 Mshowa
p
.002 w
.78536 0 m
.78536 .00625 L
s
P
[(v)] .78536 0 0 2 Mshowa
p
.002 w
.82103 0 m
.82103 .00625 L
s
P
[(w)] .82103 0 0 2 Mshowa
p
.002 w
.8567 0 m
.8567 .00625 L
s
P
[(x)] .8567 0 0 2 Mshowa
p
.002 w
.89237 0 m
.89237 .00625 L
s
P
[(y)] .89237 0 0 2 Mshowa
p
.002 w
.92804 0 m
.92804 .00625 L
s
P
[(z)] .92804 0 0 2 Mshowa
p
.002 w
.96371 0 m
.96371 .00625 L
s
P
[(_)] .96371 0 0 2 Mshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 Mshowa
p
.002 w
0 .10336 m
.00625 .10336 L
s
P
[(25)] -0.0125 .10336 1 0 Mshowa
p
.002 w
0 .19201 m
.00625 .19201 L
s
P
[(50)] -0.0125 .19201 1 0 Mshowa
p
.002 w
0 .28065 m
.00625 .28065 L
s
P
[(75)] -0.0125 .28065 1 0 Mshowa
p
.002 w
0 .3693 m
.00625 .3693 L
s
P
[(100)] -0.0125 .3693 1 0 Mshowa
p
.002 w
0 .45794 m
.00625 .45794 L
s
P
[(125)] -0.0125 .45794 1 0 Mshowa
p
.002 w
0 .54659 m
.00625 .54659 L
s
P
[(150)] -0.0125 .54659 1 0 Mshowa
p
.001 w
0 .03244 m
.00375 .03244 L
s
P
p
.001 w
0 .05017 m
.00375 .05017 L
s
P
p
.001 w
0 .0679 m
.00375 .0679 L
s
P
p
.001 w
0 .08563 m
.00375 .08563 L
s
P
p
.001 w
0 .12109 m
.00375 .12109 L
s
P
p
.001 w
0 .13882 m
.00375 .13882 L
s
P
p
.001 w
0 .15655 m
.00375 .15655 L
s
P
p
.001 w
0 .17428 m
.00375 .17428 L
s
P
p
.001 w
0 .20973 m
.00375 .20973 L
s
P
p
.001 w
0 .22746 m
.00375 .22746 L
s
P
p
.001 w
0 .24519 m
.00375 .24519 L
s
P
p
.001 w
0 .26292 m
.00375 .26292 L
s
P
p
.001 w
0 .29838 m
.00375 .29838 L
s
P
p
.001 w
0 .31611 m
.00375 .31611 L
s
P
p
.001 w
0 .33384 m
.00375 .33384 L
s
P
p
.001 w
0 .35157 m
.00375 .35157 L
s
P
p
.001 w
0 .38702 m
.00375 .38702 L
s
P
p
.001 w
0 .40475 m
.00375 .40475 L
s
P
p
.001 w
0 .42248 m
.00375 .42248 L
s
P
p
.001 w
0 .44021 m
.00375 .44021 L
s
P
p
.001 w
0 .47567 m
.00375 .47567 L
s
P
p
.001 w
0 .4934 m
.00375 .4934 L
s
P
p
.001 w
0 .51113 m
.00375 .51113 L
s
P
p
.001 w
0 .52886 m
.00375 .52886 L
s
P
p
.001 w
0 .56432 m
.00375 .56432 L
s
P
p
.001 w
0 .58204 m
.00375 .58204 L
s
P
p
.001 w
0 .59977 m
.00375 .59977 L
s
P
p
.001 w
0 .6175 m
.00375 .6175 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.03629 .61178 m
.03629 .61803 L
s
P
p
.002 w
.07196 .61178 m
.07196 .61803 L
s
P
p
.002 w
.10763 .61178 m
.10763 .61803 L
s
P
p
.002 w
.1433 .61178 m
.1433 .61803 L
s
P
p
.002 w
.17897 .61178 m
.17897 .61803 L
s
P
p
.002 w
.21464 .61178 m
.21464 .61803 L
s
P
p
.002 w
.25031 .61178 m
.25031 .61803 L
s
P
p
.002 w
.28598 .61178 m
.28598 .61803 L
s
P
p
.002 w
.32165 .61178 m
.32165 .61803 L
s
P
p
.002 w
.35732 .61178 m
.35732 .61803 L
s
P
p
.002 w
.39299 .61178 m
.39299 .61803 L
s
P
p
.002 w
.42866 .61178 m
.42866 .61803 L
s
P
p
.002 w
.46433 .61178 m
.46433 .61803 L
s
P
p
.002 w
.5 .61178 m
.5 .61803 L
s
P
p
.002 w
.53567 .61178 m
.53567 .61803 L
s
P
p
.002 w
.57134 .61178 m
.57134 .61803 L
s
P
p
.002 w
.60701 .61178 m
.60701 .61803 L
s
P
p
.002 w
.64268 .61178 m
.64268 .61803 L
s
P
p
.002 w
.67835 .61178 m
.67835 .61803 L
s
P
p
.002 w
.71402 .61178 m
.71402 .61803 L
s
P
p
.002 w
.74969 .61178 m
.74969 .61803 L
s
P
p
.002 w
.78536 .61178 m
.78536 .61803 L
s
P
p
.002 w
.82103 .61178 m
.82103 .61803 L
s
P
p
.002 w
.8567 .61178 m
.8567 .61803 L
s
P
p
.002 w
.89237 .61178 m
.89237 .61803 L
s
P
p
.002 w
.92804 .61178 m
.92804 .61803 L
s
P
p
.002 w
.96371 .61178 m
.96371 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .10336 m
1 .10336 L
s
P
p
.002 w
.99375 .19201 m
1 .19201 L
s
P
p
.002 w
.99375 .28065 m
1 .28065 L
s
P
p
.002 w
.99375 .3693 m
1 .3693 L
s
P
p
.002 w
.99375 .45794 m
1 .45794 L
s
P
p
.002 w
.99375 .54659 m
1 .54659 L
s
P
p
.001 w
.99625 .03244 m
1 .03244 L
s
P
p
.001 w
.99625 .05017 m
1 .05017 L
s
P
p
.001 w
.99625 .0679 m
1 .0679 L
s
P
p
.001 w
.99625 .08563 m
1 .08563 L
s
P
p
.001 w
.99625 .12109 m
1 .12109 L
s
P
p
.001 w
.99625 .13882 m
1 .13882 L
s
P
p
.001 w
.99625 .15655 m
1 .15655 L
s
P
p
.001 w
.99625 .17428 m
1 .17428 L
s
P
p
.001 w
.99625 .20973 m
1 .20973 L
s
P
p
.001 w
.99625 .22746 m
1 .22746 L
s
P
p
.001 w
.99625 .24519 m
1 .24519 L
s
P
p
.001 w
.99625 .26292 m
1 .26292 L
s
P
p
.001 w
.99625 .29838 m
1 .29838 L
s
P
p
.001 w
.99625 .31611 m
1 .31611 L
s
P
p
.001 w
.99625 .33384 m
1 .33384 L
s
P
p
.001 w
.99625 .35157 m
1 .35157 L
s
P
p
.001 w
.99625 .38702 m
1 .38702 L
s
P
p
.001 w
.99625 .40475 m
1 .40475 L
s
P
p
.001 w
.99625 .42248 m
1 .42248 L
s
P
p
.001 w
.99625 .44021 m
1 .44021 L
s
P
p
.001 w
.99625 .47567 m
1 .47567 L
s
P
p
.001 w
.99625 .4934 m
1 .4934 L
s
P
p
.001 w
.99625 .51113 m
1 .51113 L
s
P
p
.001 w
.99625 .52886 m
1 .52886 L
s
P
p
.001 w
.99625 .56432 m
1 .56432 L
s
P
p
.001 w
.99625 .58204 m
1 .58204 L
s
P
p
.001 w
.99625 .59977 m
1 .59977 L
s
P
p
.001 w
.99625 .6175 m
1 .6175 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
p
.6 g
.02381 .01472 m
.02381 .24165 L
.04878 .24165 L
.04878 .01472 L
F
P
p
P
P
p
p
.6 g
.05948 .01472 m
.05948 .06436 L
.08445 .06436 L
.08445 .01472 L
F
P
p
P
P
p
p
.6 g
.09515 .01472 m
.09515 .11045 L
.12012 .11045 L
.12012 .01472 L
F
P
p
P
P
p
p
.6 g
.13082 .01472 m
.13082 .13882 L
.15579 .13882 L
.15579 .01472 L
F
P
p
P
P
p
p
.6 g
.16649 .01472 m
.16649 .3693 L
.19146 .3693 L
.19146 .01472 L
F
P
p
P
P
p
p
.6 g
.20216 .01472 m
.20216 .08563 L
.22713 .08563 L
.22713 .01472 L
F
P
p
P
P
p
p
.6 g
.23783 .01472 m
.23783 .06436 L
.2628 .06436 L
.2628 .01472 L
F
P
p
P
P
p
p
.6 g
.2735 .01472 m
.2735 .16364 L
.29847 .16364 L
.29847 .01472 L
F
P
p
P
P
p
p
.6 g
.30917 .01472 m
.30917 .2381 L
.33414 .2381 L
.33414 .01472 L
F
P
p
P
P
p
p
.6 g
.34484 .01472 m
.34484 .02535 L
.36981 .02535 L
.36981 .01472 L
F
P
p
P
P
p
p
.6 g
.38051 .01472 m
.38051 .03599 L
.40548 .03599 L
.40548 .01472 L
F
P
p
P
P
p
p
.6 g
.41618 .01472 m
.41618 .13882 L
.44114 .13882 L
.44114 .01472 L
F
P
p
P
P
p
p
.6 g
.45185 .01472 m
.45185 .08563 L
.47681 .08563 L
.47681 .01472 L
F
P
p
P
P
p
p
.6 g
.48752 .01472 m
.48752 .21328 L
.51248 .21328 L
.51248 .01472 L
F
P
p
P
P
p
p
.6 g
.52319 .01472 m
.52319 .21328 L
.54815 .21328 L
.54815 .01472 L
F
P
p
P
P
p
p
.6 g
.55886 .01472 m
.55886 .07499 L
.58382 .07499 L
.58382 .01472 L
F
P
p
P
P
p
p
.6 g
.59452 .01472 m
.59452 .0289 L
.61949 .0289 L
.61949 .01472 L
F
P
p
P
P
p
p
.6 g
.63019 .01472 m
.63019 .18846 L
.65516 .18846 L
.65516 .01472 L
F
P
p
P
P
p
p
.6 g
.66586 .01472 m
.66586 .21328 L
.69083 .21328 L
.69083 .01472 L
F
P
p
P
P
p
p
.6 g
.70153 .01472 m
.70153 .26647 L
.7265 .26647 L
.7265 .01472 L
F
P
p
P
P
p
p
.6 g
.7372 .01472 m
.7372 .12464 L
.76217 .12464 L
.76217 .01472 L
F
P
p
P
P
p
p
.6 g
.77287 .01472 m
.77287 .05017 L
.79784 .05017 L
.79784 .01472 L
F
P
p
P
P
p
p
.6 g
.80854 .01472 m
.80854 .07854 L
.83351 .07854 L
.83351 .01472 L
F
P
p
P
P
p
p
.6 g
.84421 .01472 m
.84421 .02535 L
.86918 .02535 L
.86918 .01472 L
F
P
p
P
P
p
p
.6 g
.87988 .01472 m
.87988 .07854 L
.90485 .07854 L
.90485 .01472 L
F
P
p
P
P
p
p
.6 g
.91555 .01472 m
.91555 .02181 L
.94052 .02181 L
.94052 .01472 L
F
P
p
P
P
p
p
.6 g
.95122 .01472 m
.95122 .60332 L
.97619 .60332 L
.97619 .01472 L
F
P
p
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; locked; preserveAspect; endGroup; endGroup; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
^*)
